<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * Message.
 */
class Message  {

  /*
   * @type SendingAs
   */
  public $sendingAs;

  /*
   * @type List
   */
  public $to;

  /*
   * @type List
   */
  public $cc;

  /*
   * @type List
   */
  public $recipients;

  /*
   * @type String
   */
  public $subject;

  /*
   * Constructor
   */
  public function __construct() {
    $this->sendingAs =   new SendingAs();
    $this->to =  array();
    $this->cc =  array();
    $this->recipients =  array();
    $this->subject = "";
  }

  public function toMap() {
    $data = array(    
        "sendingAs" => empty($this->sendingAs) ? null : $this->sendingAs,    
        "to" => empty($this->to) ? null : $this->to,    
        "cc" => empty($this->cc) ? null : $this->cc,    
        "recipients" => empty($this->recipients) ? null : $this->recipients,    
        "subject" => empty($this->subject) ? null : $this->subject);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
