package net.bluemind.system.cql.store.factories;

import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.rest.BmContext;
import net.bluemind.cql.persistence.CqlRepositoryFactory;
import net.bluemind.repository.provider.IStandaloneFactory;
import net.bluemind.system.cql.store.CqlCredentialsStore;
import net.bluemind.system.repository.ICredentialsStore;

public class CredentialsStoreFactory extends CqlRepositoryFactory<ICredentialsStore>
		implements IStandaloneFactory<ICredentialsStore> {

	@Override
	public Class<ICredentialsStore> factoryClass() {
		return ICredentialsStore.class;
	}

	@Override
	public ICredentialsStore instance(BmContext context) throws ServerFault {
		return new CqlCredentialsStore(context);
	}

}
