/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.system.cql.store;

import java.sql.SQLException;
import java.util.List;

import com.datastax.oss.driver.api.core.CqlSession;

import net.bluemind.cql.persistence.CqlAbstractStore;
import net.bluemind.system.api.Database;
import net.bluemind.system.repository.ComponentVersion;
import net.bluemind.system.repository.IUpgraderStore;
import net.bluemind.system.repository.Upgrader;

public class CqlUpgraderStore extends CqlAbstractStore implements IUpgraderStore {

	public CqlUpgraderStore(CqlSession s) {
		super(s);
	}

	@Override
	public void store(Upgrader value) {
		// TODO Auto-generated method stub
		System.err.println("store " + value);
	}

	@Override
	public boolean upgraderCompleted(String upgraderId, String server, Database database) throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public List<ComponentVersion> getComponentsVersion() throws SQLException {
		return map("select component, version from t_component_version",
				r -> new ComponentVersion(r.getString(0), r.getString(1)), voidPop());
	}

	@Override
	public void updateComponentVersion(String component, String version) throws SQLException {
		voidCql("update t_component_version set version=? where component=?", version, component);
	}

	@Override
	public boolean upgraderRegistered(String upgraderId, String server, Database database) throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean needsMigration() throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

}
