/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.calendar.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class VEventChangesItemModifyGwtSerDer implements GwtSerDer<net.bluemind.calendar.api.VEventChanges.ItemModify> {

	public VEventChangesItemModifyGwtSerDer( ) {
	}

	@Override
	public net.bluemind.calendar.api.VEventChanges.ItemModify deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.calendar.api.VEventChanges.ItemModify ret = new net.bluemind.calendar.api.VEventChanges.ItemModify();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.calendar.api.VEventChanges.ItemModify ret, JSONObject json) {
		JSONValue uidJSON = json.get("uid");
		ret.uid =  GwtSerDerUtils.STRING.deserialize(uidJSON);
		JSONValue valueJSON = json.get("value");
		ret.value =  new net.bluemind.calendar.api.gwt.serder.VEventSeriesGwtSerDer().deserialize(valueJSON);
		JSONValue sendNotificationJSON = json.get("sendNotification");
		ret.sendNotification =  GwtSerDerUtils.BOOLEAN.deserialize(sendNotificationJSON);
	}

	public void deserializeTo(net.bluemind.calendar.api.VEventChanges.ItemModify ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("uid")) {
			JSONValue uidJSON = json.get("uid");
			ret.uid =  GwtSerDerUtils.STRING.deserialize(uidJSON);
		}
		if (!childPropertiesToIgnore.contains("value")) {
			JSONValue valueJSON = json.get("value");
			ret.value =  new net.bluemind.calendar.api.gwt.serder.VEventSeriesGwtSerDer().deserialize(valueJSON);
		}
		if (!childPropertiesToIgnore.contains("sendNotification")) {
			JSONValue sendNotificationJSON = json.get("sendNotification");
			ret.sendNotification =  GwtSerDerUtils.BOOLEAN.deserialize(sendNotificationJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.calendar.api.VEventChanges.ItemModify o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.calendar.api.VEventChanges.ItemModify o, JSONObject ret) {

		ret.put("uid",  GwtSerDerUtils.STRING.serialize( o.uid ));
		ret.put("value",  new net.bluemind.calendar.api.gwt.serder.VEventSeriesGwtSerDer().serialize( o.value ));
		ret.put("sendNotification",  GwtSerDerUtils.BOOLEAN.serialize( o.sendNotification ));
	}

	public void serializeTo(net.bluemind.calendar.api.VEventChanges.ItemModify o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("uid")) {
			ret.put("uid",  GwtSerDerUtils.STRING.serialize( o.uid ));
		}
		if (!childPropertiesToIgnore.contains("value")) {
			ret.put("value",  new net.bluemind.calendar.api.gwt.serder.VEventSeriesGwtSerDer().serialize( o.value ));
		}
		if (!childPropertiesToIgnore.contains("sendNotification")) {
			ret.put("sendNotification",  GwtSerDerUtils.BOOLEAN.serialize( o.sendNotification ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}