/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.calendar.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class VEventAttendeeQueryGwtSerDer implements GwtSerDer<net.bluemind.calendar.api.VEventAttendeeQuery> {

	public VEventAttendeeQueryGwtSerDer( ) {
	}

	@Override
	public net.bluemind.calendar.api.VEventAttendeeQuery deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.calendar.api.VEventAttendeeQuery ret = new net.bluemind.calendar.api.VEventAttendeeQuery();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.calendar.api.VEventAttendeeQuery ret, JSONObject json) {
		JSONValue dirJSON = json.get("dir");
		ret.dir =  GwtSerDerUtils.STRING.deserialize(dirJSON);
		JSONValue calendarOwnerAsDirJSON = json.get("calendarOwnerAsDir");
		ret.calendarOwnerAsDir =  GwtSerDerUtils.BOOLEAN.deserialize(calendarOwnerAsDirJSON);
		JSONValue partStatusJSON = json.get("partStatus");
		ret.partStatus =  new net.bluemind.icalendar.api.gwt.serder.ICalendarElementParticipationStatusGwtSerDer().deserialize(partStatusJSON);
	}

	public void deserializeTo(net.bluemind.calendar.api.VEventAttendeeQuery ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("dir")) {
			JSONValue dirJSON = json.get("dir");
			ret.dir =  GwtSerDerUtils.STRING.deserialize(dirJSON);
		}
		if (!childPropertiesToIgnore.contains("calendarOwnerAsDir")) {
			JSONValue calendarOwnerAsDirJSON = json.get("calendarOwnerAsDir");
			ret.calendarOwnerAsDir =  GwtSerDerUtils.BOOLEAN.deserialize(calendarOwnerAsDirJSON);
		}
		if (!childPropertiesToIgnore.contains("partStatus")) {
			JSONValue partStatusJSON = json.get("partStatus");
			ret.partStatus =  new net.bluemind.icalendar.api.gwt.serder.ICalendarElementParticipationStatusGwtSerDer().deserialize(partStatusJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.calendar.api.VEventAttendeeQuery o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.calendar.api.VEventAttendeeQuery o, JSONObject ret) {

		ret.put("dir",  GwtSerDerUtils.STRING.serialize( o.dir ));
		ret.put("calendarOwnerAsDir",  GwtSerDerUtils.BOOLEAN.serialize( o.calendarOwnerAsDir ));
		ret.put("partStatus",  new net.bluemind.icalendar.api.gwt.serder.ICalendarElementParticipationStatusGwtSerDer().serialize( o.partStatus ));
	}

	public void serializeTo(net.bluemind.calendar.api.VEventAttendeeQuery o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("dir")) {
			ret.put("dir",  GwtSerDerUtils.STRING.serialize( o.dir ));
		}
		if (!childPropertiesToIgnore.contains("calendarOwnerAsDir")) {
			ret.put("calendarOwnerAsDir",  GwtSerDerUtils.BOOLEAN.serialize( o.calendarOwnerAsDir ));
		}
		if (!childPropertiesToIgnore.contains("partStatus")) {
			ret.put("partStatus",  new net.bluemind.icalendar.api.gwt.serder.ICalendarElementParticipationStatusGwtSerDer().serialize( o.partStatus ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}