/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.calendar.api.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsVFreebusyType extends JavaScriptObject {

	protected JsVFreebusyType() {}

   public final native String value() 
   /*-{
   	return this;
   }-*/;

	public static final native JsVFreebusyType FREE()
	/*-{
		return "FREE";
	}-*/;

	public static final native JsVFreebusyType BUSY()
	/*-{
		return "BUSY";
	}-*/;

	public static final native JsVFreebusyType BUSYUNAVAILABLE()
	/*-{
		return "BUSYUNAVAILABLE";
	}-*/;

	public static final native JsVFreebusyType BUSYTENTATIVE()
	/*-{
		return "BUSYTENTATIVE";
	}-*/;

	public static final JsVFreebusyType create(net.bluemind.calendar.api.VFreebusy.Type value) {
		if (value == null) {
			return null;
		} else {
			switch (value) {
			case FREE:
				return FREE();
			case BUSY:
				return BUSY();
			case BUSYUNAVAILABLE:
				return BUSYUNAVAILABLE();
			case BUSYTENTATIVE:
				return BUSYTENTATIVE();
			default:
				return null;
			}
		}
	}
}