/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.resource.api.type.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class ResourceTypeDescriptorGwtSerDer implements GwtSerDer<net.bluemind.resource.api.type.ResourceTypeDescriptor> {

	public ResourceTypeDescriptorGwtSerDer( ) {
	}

	@Override
	public net.bluemind.resource.api.type.ResourceTypeDescriptor deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.resource.api.type.ResourceTypeDescriptor ret = new net.bluemind.resource.api.type.ResourceTypeDescriptor();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.resource.api.type.ResourceTypeDescriptor ret, JSONObject json) {
		JSONValue labelJSON = json.get("label");
		ret.label =  GwtSerDerUtils.STRING.deserialize(labelJSON);
		JSONValue propertiesJSON = json.get("properties");
		ret.properties =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.resource.api.type.gwt.serder.ResourceTypeDescriptorPropertyGwtSerDer()).deserialize(propertiesJSON);
		JSONValue templatesJSON = json.get("templates");
		ret.templates =  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).deserialize(templatesJSON);
	}

	public void deserializeTo(net.bluemind.resource.api.type.ResourceTypeDescriptor ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("label")) {
			JSONValue labelJSON = json.get("label");
			ret.label =  GwtSerDerUtils.STRING.deserialize(labelJSON);
		}
		if (!childPropertiesToIgnore.contains("properties")) {
			JSONValue propertiesJSON = json.get("properties");
			ret.properties =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.resource.api.type.gwt.serder.ResourceTypeDescriptorPropertyGwtSerDer()).deserialize(propertiesJSON);
		}
		if (!childPropertiesToIgnore.contains("templates")) {
			JSONValue templatesJSON = json.get("templates");
			ret.templates =  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).deserialize(templatesJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.resource.api.type.ResourceTypeDescriptor o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.resource.api.type.ResourceTypeDescriptor o, JSONObject ret) {

		ret.put("label",  GwtSerDerUtils.STRING.serialize( o.label ));
		ret.put("properties",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.resource.api.type.gwt.serder.ResourceTypeDescriptorPropertyGwtSerDer()).serialize( o.properties ));
		ret.put("templates",  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).serialize( o.templates ));
	}

	public void serializeTo(net.bluemind.resource.api.type.ResourceTypeDescriptor o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("label")) {
			ret.put("label",  GwtSerDerUtils.STRING.serialize( o.label ));
		}
		if (!childPropertiesToIgnore.contains("properties")) {
			ret.put("properties",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.resource.api.type.gwt.serder.ResourceTypeDescriptorPropertyGwtSerDer()).serialize( o.properties ));
		}
		if (!childPropertiesToIgnore.contains("templates")) {
			ret.put("templates",  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).serialize( o.templates ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}