/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.resource.api.type.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;
import java.util.concurrent.CompletableFuture;

public class ResourceTypesEndpointPromise implements net.bluemind.resource.api.type.IResourceTypesPromise {

	private net.bluemind.resource.api.type.IResourceTypesAsync impl;

	public ResourceTypesEndpointPromise(net.bluemind.resource.api.type.IResourceTypesAsync impl) {
		this.impl = impl;
	}

	@Override
	public CompletableFuture<Void> create(String identifier ,  net.bluemind.resource.api.type.ResourceTypeDescriptor resourceTypeDescriptor  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.create(identifier, resourceTypeDescriptor,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> delete(String uid  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.delete(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.resource.api.type.ResourceTypeDescriptor> get(String uid  ) {
		
		CompletableFuture<net.bluemind.resource.api.type.ResourceTypeDescriptor> ret = new CompletableFuture<net.bluemind.resource.api.type.ResourceTypeDescriptor>();
		AsyncHandler<net.bluemind.resource.api.type.ResourceTypeDescriptor> handler = new AsyncHandler<net.bluemind.resource.api.type.ResourceTypeDescriptor>() {
			public void success(net.bluemind.resource.api.type.ResourceTypeDescriptor value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.get(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<byte[]> getIcon(String uid  ) {
		
		CompletableFuture<byte[]> ret = new CompletableFuture<byte[]>();
		AsyncHandler<byte[]> handler = new AsyncHandler<byte[]>() {
			public void success(byte[] value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getIcon(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.resource.api.type.ResourceType>> getTypes() {
		
		CompletableFuture<List<net.bluemind.resource.api.type.ResourceType>> ret = new CompletableFuture<List<net.bluemind.resource.api.type.ResourceType>>();
		AsyncHandler<List<net.bluemind.resource.api.type.ResourceType>> handler = new AsyncHandler<List<net.bluemind.resource.api.type.ResourceType>>() {
			public void success(List<net.bluemind.resource.api.type.ResourceType> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getTypes( handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> setIcon(String uid ,  byte[] icon  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.setIcon(uid, icon,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> update(String uid ,  net.bluemind.resource.api.type.ResourceTypeDescriptor resourceTypeDescriptor  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.update(uid, resourceTypeDescriptor,  handler);
		return ret;
	}

}
