import i18n from "@bluemind/i18n";

import { Parameters } from "../parameters.type";

export function textContent(parameters: Parameters) {
    return `${i18n.global.t("template.eml.mdn.html")}\n\n    ${i18n.global.t("common.to")} : ${
        parameters.from
    }    ${i18n.global.t("common.subject")} : ${parameters.subject}\n    ${i18n.global.t("common.date")} : ${
        parameters.date
    }\n\n${i18n.global.t("template.eml.mdn.html.notice")}`;
}

export function htmlContent(parameters: Parameters) {
    return `${i18n.global.t(
        "template.eml.mdn.html"
    )}<blockquote style="border-left: 1px solid var(--neutral-fg-lo2, rgba(83, 83, 83, 0.4)); padding-left: 10px;"><strong>${i18n.global.t(
        "common.to"
    )} : </strong>${parameters.from}<br><strong>${i18n.global.t("common.subject")} : </strong>${
        parameters.subject
    }<br><strong>${i18n.global.t("common.date")} : </strong>${parameters.date}<br></blockquote><em>${i18n.global.t(
        "template.eml.mdn.html.notice"
    )}</em>`;
}

export function reportContent(parameters: Parameters) {
    return `Reporting-UA: BlueMind Mail App\n\n${
        parameters.originalRecipient ? "Original-Recipient: " + parameters.originalRecipient + "\n\n" : ""
    }Final-Recipient: rfc822; ${parameters.toAddress}\nOriginal-Message-ID: ${
        parameters.messageId
    }\nDisposition: manual-action/MDN-sent-manually; displayed`;
}
