import { inject } from "@bluemind/inject";
import { messageUtils } from "@bluemind/mail";
import { retrieveTaskResult } from "@bluemind/task";

import getMDNStructure from "../../../utils/eml-templates/templates/MDN/structure";

const { generateMessageIDHeader, MessageHeader, MessageAdaptor } = messageUtils;

export default async function sendMDNTemplate(store, { parameters, from, to, outboxUid, additionalHeaders }) {
    const service = inject("MailboxItemsPersistence", outboxUid);
    const structure = getMDNStructure(parameters);
    const subject = structure.subject;
    delete structure.subject;
    await walk(structure, structureNode => createPart(structureNode, parameters, service));
    const date = new Date();
    const message = {
        from,
        to: [to],
        subject,
        date,
        headers: [
            generateMessageIDHeader(from.address),
            { name: MessageHeader.X_BM_DRAFT_REFRESH_DATE, values: [date.getTime()] },
            ...additionalHeaders
        ],
        remoteRef: { internaId: 0 }
    };
    const mailboxItem = MessageAdaptor.toMailboxItem(message, structure);
    await service.create(mailboxItem);
    await inject("OutboxPersistence")
        .flush()
        .then(taskRef => {
            const taskService = inject("TaskService", taskRef.id);
            return retrieveTaskResult(taskService);
        });
    return { recipient: to.dn || to.address };
}

async function walk(structureNode, fn) {
    await fn(structureNode);
    const promises = [];
    structureNode.children?.forEach(child => promises.push(walk(child, fn)));
    return Promise.all(promises);
}

async function createPart(structureNode, parameters, service) {
    if (!structureNode.children?.length) {
        structureNode.address = await service.uploadPart(structureNode.content);
        delete structureNode.content;
    }
}
