import apiFolders from "./apiFolders";

const counters = vi.fn(() => Promise.resolve([42]));

vi.mock("@bluemind/inject", () => {
    return {
        inject: service => {
            if (service === "MailboxFoldersPersistence") {
                return { counters };
            }
        }
    };
});

describe("apiFolders", () => {
    describe("unreadCounts", () => {
        it("should chunk calls to 'counters' API", async () => {
            const folders = [
                { remoteRef: { internalId: 1 } },
                { remoteRef: { internalId: 2 } },
                { remoteRef: { internalId: 3 } },
                { remoteRef: { internalId: 4 } },
                { remoteRef: { internalId: 5 } }
            ];
            const mailbox = { remoteRef: "mboxRef" };
            const chunkSize = 2;
            await apiFolders.unreadCounts(mailbox, folders, chunkSize);

            expect(counters).toHaveBeenCalledTimes(3);
        });
        it("should return an array of numbers", async () => {
             const folders = [
                { remoteRef: { internalId: 1 } },
                { remoteRef: { internalId: 2 } }
            ];
            const mailbox = { remoteRef: "mboxRef" };
            const chunkSize = 1;
            const result = await apiFolders.unreadCounts(mailbox, folders, chunkSize);

            expect(result).toEqual([42, 42])
        })
    });
});
