import { SEND_MESSAGE } from "~/actions";
import { ADDRESS_AUTOCOMPLETE } from "~/getters";
import { INCREASE_ADDRESS_WEIGHT, DELETE_ADDRESS_WEIGHTS, EXCLUDE_ADDRESS } from "~/mutations";

const WEIGHT_STEP = 60 * 60 * 24 * 10;
const MAX_WEIGHT = 18 * WEIGHT_STEP;
export default {
    state: {
        addressWeights: {},
        synced: { addressWeights: [INCREASE_ADDRESS_WEIGHT, DELETE_ADDRESS_WEIGHTS, EXCLUDE_ADDRESS] }
    },

    mutations: {
        [INCREASE_ADDRESS_WEIGHT]: (state, { address }) => {
            const now = Date.now();
            const current = Math.min(Math.max(0, (state.addressWeights[address] || 0) - now), MAX_WEIGHT);
            state.addressWeights[address] = current + now + WEIGHT_STEP;
        },
        [EXCLUDE_ADDRESS]: (state, { address }) => {
            state.addressWeights[address] = -1;
        },
        [DELETE_ADDRESS_WEIGHTS]: state => {
            state.addressWeights = {};
        }
    },

    getters: {
        [ADDRESS_AUTOCOMPLETE]: state => {
            const addressAutoComplete = { sortedAddresses: [], excludedAddresses: [] };
            Object.keys(state.addressWeights).forEach(address => {
                state.addressWeights[address] >= 0
                    ? addressAutoComplete.sortedAddresses.push(address)
                    : addressAutoComplete.excludedAddresses.push(address);
            });
            addressAutoComplete.sortedAddresses.sort((a, b) => state.addressWeights[a] - state.addressWeights[b]);
            return addressAutoComplete;
        }
    },

    actions: {
        [SEND_MESSAGE]: (store, { draft }) => {
            const sentAddresses = new Set(
                draft.to
                    .concat(draft.cc)
                    .concat(draft.bcc)
                    .map(({ address }) => address)
            );
            sentAddresses.forEach(address => store.commit(INCREASE_ADDRESS_WEIGHT, { address }));
        }
    }
};
