import { showNotification } from "@bluemind/commons/utils/notification";
import { extensions } from "@bluemind/extensions";
import app from "@bluemind/global.app";

import { TranslationRegistry } from "@bluemind/i18n";
import { inject } from "@bluemind/inject";
import BmRoles from "@bluemind/roles";
import router from "@bluemind/router";
import WebsocketClient from "@bluemind/sockjs";

import MailAppL10N from "../l10n/";

import * as MailAlertComponents from "./components/MailAlerts";
import * as ThreadAlertComponents from "./components/MailThread/Alerts";
import MailViewerContent from "./components/MailViewer/MailViewerContent";
import registerAPIClients from "./registerApiClients";
import registerExtensions from "./registerExtensions";
import mailRoutes from "./router";

TranslationRegistry.register(MailAppL10N);

// router.addRoute({
//     path: "/mail",
//     component: MailApp
// });
// console.log(router);
registerExtensions();
registerAPIClients();

mailRoutes.forEach(route => {
    router.addRoute(route);
});
registerMailtoHandler();
addNewMailNotification(inject("UserSession"));
// FIXME allow to use MailViewerContent in MessageFileViewer (avoid to import it due to circular dependency issue)
app.component("MailViewerContent", MailViewerContent);
// app.component("MailWebapp", MailApp);
const AlertComponents = { ...MailAlertComponents, ...ThreadAlertComponents };
for (let component in AlertComponents) {
    app.component(component, AlertComponents[component]);
}

function registerMailtoHandler() {
    // Firefox based browsers registering popup has no "block" option, they will spam the user indefinitely
    if (window.navigator.registerProtocolHandler && !/firefox/i.test(navigator.userAgent)) {
        window.navigator.registerProtocolHandler("mailto", "/webapp/mail/%s", "Mailto Handler");
    }
}

const refreshFolderDelay = 5000;
async function addNewMailNotification(userSession) {
    if (userSession.roles.includes(BmRoles.HAS_MAIL)) {
        const application = extensions
            .get("net.bluemind.webapp", "application")
            .find(application => application.$bundle === "net.bluemind.webapp.mail.js");
        const icon = URL.createObjectURL(new Blob([application.icon.svg.toString()], { type: "image/svg+xml" }));
        const address = `${userSession.userId}.notifications.mails`;

        new WebsocketClient().register(address, async ({ data: { body: data } }) => {
            const tag = `notifications.mails`;
            const renotify = true;
            await wait(refreshFolderDelay);
            showNotification(data.title, { body: data.body, icon, badge: icon, image: icon, data, tag, renotify });
        });
    }
}
function wait(ms) {
    return new Promise(resolve => setTimeout(resolve, ms));
}
