import PathParam, { messageOrRelated } from "./PathParam";

export default class ConversationPathParam extends PathParam {
    static parse(path: string, defaultFolder: string) {
        return PathParam._parse(path, defaultFolder, (id: string) => id);
    }

    static build(path: string, conversation: messageOrRelated, action: string, related: messageOrRelated) {
        if (conversation === undefined) {
            return path;
        } else if (conversation) {
            let builtPath = conversation.folderRef.key + ":" + conversation.remoteRef.uid;
            if (action) {
                builtPath += ":" + action;
            }
            if (related) {
                builtPath += ":" + related.folderRef.key + ":" + related.remoteRef.internalId;
            }
            return builtPath;
        }
    }
}
