import ComposerActionsMixin from "./ComposerActionsMixin";

export default {
    mixins: [ComposerActionsMixin],
    props: {
        message: { type: Object, required: true },
        showReplyTo: { type: Boolean, default: undefined }
    },
    data() {
        return { showCc: undefined, showBcc: undefined };
    },
    watch: {
        "message.cc": {
            handler() {
                this.showCc = this.showCc || this.message.cc.length > 0;
            },
            immediate: true
        },
        "message.bcc": {
            handler() {
                this.showBcc = this.showBcc || this.message.bcc.length > 0;
            },
            immediate: true
        }
    }
};
