import { computed, onBeforeUnmount, ref } from "vue";

import { whenever } from "@bluemind/commons/vue/watch";
import { BaseContainerDescriptor, BaseContainerDescriptor as Mailbox } from "@bluemind/core.container.api";
import WebSocketClient from "@bluemind/sockjs";
import store from "@bluemind/store";

import { MAILBOXES, MAILBOXES_ARE_LOADED } from "../store/types/getters";

type Listener = () => void;

const TAG_CONTAINER_PREFIX = "tags.tags_";

const webSocketClient = new WebSocketClient();

export default function observeTagsChange() {
    const listeners = ref<Listener[]>([]);

    const loaded = computed(() => store.getters[`mail/${MAILBOXES_ARE_LOADED}`]);
    const mailboxes = computed<Mailbox[]>(() => store.getters[`mail/${MAILBOXES}`]);

    function observeTags(callback: (...args: unknown[]) => void) {
        whenever(loaded, () => register(), { once: true, immediate: true });

        function register() {
            mailboxes.value.forEach(mailbox => {
                webSocketClient.register(tagContainerPath(mailbox), callback);
                listeners.value.push(() => webSocketClient.unregister(tagContainerPath(mailbox), callback));
            });
        }
    }

    function tagContainerPath(mailbox: BaseContainerDescriptor) {
        return TAG_CONTAINER_PREFIX + mailbox.owner;
    }

    onBeforeUnmount(() => listeners.value.forEach(unregisterListener => unregisterListener()));

    return { observeTags };
}
