import { mapState } from "vuex";

import { throttle } from "@bluemind/commons/utils/function";

export default {
    data: () => ({ listenerRegistry: [] }),
    computed: {
        ...mapState("mail", ["folders"])
    },
    async created() {
        this.$bus.$on("container:updated", this.handleContainerUpdate);
    },
    beforeUnmount() {
        this.listenerRegistry.forEach(unregister => unregister());
        this.$bus.$off("container:updated", this.handleContainerUpdate);
    },
    methods: {
        handleContainerUpdate(event, payload) {
            if (payload?.uid) {
                this.refreshUI(payload.uid);
            }
        },

        async refreshUI(folderUid) {
            if (folderUid in this.folders) {
                this.$bus.$emit("mail-webapp/unread_folder_count", this.folders[folderUid]);
                refreshFolder(folderUid, this.$bus);
            }
        }
    }
};

const folderUidUpdateQueue = new Set();

const throttledFolderChanges = throttle(bus => {
    folderUidUpdateQueue.forEach(folderUid => bus.$emit("mail-webapp/pushed_folder_changes", folderUid));
    folderUidUpdateQueue.clear();
}, 5000);
function refreshFolder(folderUid, bus) {
    folderUidUpdateQueue.add(folderUid);
    throttledFolderChanges(bus);
}
