import { markRaw } from "vue";

import { DefaultAlert } from "@bluemind/alert.store";
import { AlertTypes, useDispatchAlert } from "@bluemind/bluetiful";
import { Payload } from "@bluemind/command";
import store from "@bluemind/store";
import UUIDGenerator from "@bluemind/uuid";

export async function withAlert(actionName: string, path: string, payload: Payload) {
    const { dispatchAlert } = useDispatchAlert();
    const uid = UUIDGenerator.generate();
    const component = markRaw(DefaultAlert);

    try {
        const result = await store.dispatch(actionName, payload);
        dispatchAlert({
            uid,
            type: AlertTypes.SUCCESS,
            renderer: { component, props: { payload: result, name: path } }
        });
        return result;
    } catch (e) {
        dispatchAlert({ uid, type: AlertTypes.ERROR, renderer: { component, props: { name: path, error: e } } });
        throw e;
    }
}
