import { useCommand } from "@bluemind/command";
import { inject } from "@bluemind/inject";
import store from "@bluemind/store";

import { SET_MAIL_TIPS } from "~/mutations";

async function getMailTips({ context }) {
    if (context.filter.mailTips.length > 0) {
        const mailTips = await inject("MailTipPersistence").getMailTips(context);
        store.commit(`mail/${SET_MAIL_TIPS}`, mailTips);
    } else {
        store.commit(`mail/${SET_MAIL_TIPS}`, []);
    }
}

export default { commands: { getMailTips } };
export const useGetMailTipsCommand = () => useCommand("getMailTips", getMailTips);
