import { extensions } from "@bluemind/extensions";

import MailboxItemSyncService from "./MailboxItemSyncService";
import { MailboxRecordsDB } from "./MailboxRecordsDB";
import MailboxSyncService from "./MailboxSyncService";
import { ReplicatedMailboxesDB } from "./ReplicatedMailboxesDB";

export const mailService = {
    register() {
        extensions.register("serviceworker.handlers", "net.bluemind.vue-apps.service-workers", {
            "sync-handlers": {
                priority: 128,
                class: MailboxSyncService,
                type: "mailboxacl"
            }
        });
        extensions.register("serviceworker.handlers", "net.bluemind.vue-apps.service-workers", {
            "containerdb-handlers": {
                priority: 128,
                class: ReplicatedMailboxesDB,
                type: "mailboxacl"
            }
        });

        extensions.register("serviceworker.handlers", "net.bluemind.vue-apps.service-workers", {
            "sync-handlers": {
                priority: 128,
                class: MailboxItemSyncService,
                type: "mail_record"
            }
        });
        extensions.register("serviceworker.handlers", "net.bluemind.vue-apps.service-workers", {
            "containerdb-handlers": {
                priority: 128,
                class: MailboxRecordsDB,
                type: "mail_record"
            }
        });
    }
};
