import { RouteMatchCallbackOptions } from "workbox-core";

import logger from "@bluemind/logger";

const handlers: string[] = [];
const assets: string[] = [];
let lock: Promise<void> | undefined;
export default {
    load() {
        return loadResourceList();
    },
    async getAssetList(): Promise<string[]> {
        await loadResourceList();
        return assets;
    },
    async getHandlerList(): Promise<string[]> {
        await loadResourceList();
        return handlers;
    },
    isAsset(options: RouteMatchCallbackOptions): boolean {
        loadResourceList();
        return !!(assets?.includes(options.url.pathname.replace(/^\/webapp\//, "")) && options.sameOrigin);
    },
    isHandler(options: RouteMatchCallbackOptions): boolean {
        loadResourceList();
        return !!(handlers?.includes(options.url.pathname.replace(/^\/webapp\//, "")) && options.sameOrigin);
    }
};
function isLoaded() {
    return lock !== undefined;
}
function loadResourceList() {
    if (!isLoaded()) {
        lock = setResourceList().catch(error => {
            logger.error("[ResourceListProvider] Fail to fetch resource list ", error);
            lock = undefined;
        });
    }
    return lock;
}

async function setResourceList() {
    const response = await fetch("/webapp/resource-list.json");
    if (response?.ok && !response.redirected) {
        const resources = await response.json();
        handlers.splice(0, handlers.length, ...resources.handlers);
        assets.splice(0, assets.length, ...resources.assets);
    } else {
        throw new Error(`HTTP ${response.status}: ${response.statusText}`);
    }
}
