import { ItemIdType, SyncService } from "@bluemind/commons.light/model/synchronization";
import logger from "@bluemind/logger";
import session from "@bluemind/session";

type SyncServiceClass<T, K extends ItemIdType> = new (uid: string, sid: string, domain: string) => SyncService<T, K>;
export default {
    registry: new Map() as Map<string, SyncServiceClass<unknown, ItemIdType>>,
    async get<T, K extends ItemIdType>(uid: string, type: string): Promise<SyncService<T, K> | undefined> {
        const syncServiceClass = this.registry.get(type) as SyncServiceClass<T, K>;
        if (syncServiceClass) {
            try {
                return new syncServiceClass(uid, session.sid, session.domain);
            } catch (error) {
                logger.error(
                    `[SyncServiceProvider] Fail to create sync service for uid ${uid} and type ${type}`,
                    error
                );
                return undefined;
            }
        }
    },
    register<T, K extends ItemIdType>(syncServiceClass: SyncServiceClass<T, K>, type: string) {
        this.registry.set(type, syncServiceClass);
    }
};
