/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.core.backup.continuous.restore.index;

import net.bluemind.core.backup.continuous.model.RecordKey;

public class IndexKeys {

	private IndexKeys() {
	}

	public static String deletion(RecordKey rk) {
		return deletion(rk.uid, rk.id);
	}

	public static String deletion(String containerUid, String uid) {
		return containerUid + "/uid:" + uid;
	}

	public static String deletion(String containerUid, long itemId) {
		return containerUid + "/id:" + itemId;
	}

}
