package net.bluemind.core.backup.continuous.restore.domains;

import java.util.List;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;

import net.bluemind.core.backup.continuous.DataElement;
import net.bluemind.core.container.model.ItemValue;
import net.bluemind.core.rest.IServiceProvider;
import net.bluemind.core.utils.JsonUtils;
import net.bluemind.core.utils.JsonUtils.ValueReader;
import net.bluemind.exchange.mapi.api.IMapiPidMapping;
import net.bluemind.exchange.mapi.api.MapiPidMapping;

public class RestorePid {

	private static final ValueReader<ItemValue<MapiPidMapping>> reader = JsonUtils
			.reader(new TypeReference<ItemValue<MapiPidMapping>>() {
			});

	private RestoreLogger log;
	private Supplier<IMapiPidMapping> api;

	public RestorePid(RestoreLogger log, IServiceProvider target) {
		this.log = log;
		api = Suppliers.memoize(() -> target.instance(IMapiPidMapping.class));
	}

	public void restore(List<DataElement> pidRecords) {
		api.get().saveBatch(pidRecords.stream().map(pidRecord -> reader.read(pidRecord.payload).value).toList());
	}

}
