package net.bluemind.core.backup.continuous.restore.domains;

import java.util.function.Supplier;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Suppliers;

import net.bluemind.core.backup.continuous.model.RecordKey;
import net.bluemind.core.backup.continuous.model.RecordKey.Operation;
import net.bluemind.core.container.model.ItemValue;
import net.bluemind.core.rest.IServiceProvider;
import net.bluemind.core.utils.JsonUtils;
import net.bluemind.core.utils.JsonUtils.ValueReader;
import net.bluemind.exchange.mapi.api.IMapiPCLCache;
import net.bluemind.exchange.mapi.api.KafkaPCLCacheEntry;
import net.bluemind.exchange.mapi.api.MapiPCLCacheEntry;

public class RestorePcl implements RestoreDomainType {

	private static final ValueReader<ItemValue<KafkaPCLCacheEntry>> reader = JsonUtils
			.reader(new TypeReference<ItemValue<KafkaPCLCacheEntry>>() {
			});
	private final IServiceProvider target;
	private Supplier<IMapiPCLCache> api;
	private RestoreLogger log;

	public RestorePcl(RestoreLogger log, IServiceProvider target) {
		this.target = target;
		this.log = log;
		api = Suppliers.memoize(() -> target.instance(IMapiPCLCache.class));
	}

	@Override
	public String type() {
		return KafkaPCLCacheEntry.TYPE;
	}

	@Override
	public void restore(RecordKey key, String payload) {
		switch (Operation.of(key)) {
		case Operation.CREATE: {
			log.create(type(), key);
			ItemValue<KafkaPCLCacheEntry> itemvalue = reader.read(payload);
			KafkaPCLCacheEntry entry = itemvalue.value;
			api.get().store(entry.replicaGuid(), entry.globalCounter(), new MapiPCLCacheEntry(entry.modificationNanos(),
					entry.serverReplicaGuid(), entry.version(), entry.changekeySize()));
			break;
		}
		case Operation.DELETE: {
			log.delete(type(), key);
			KafkaPCLCacheEntry entry = reader.read(payload).value;
			api.get().delete(entry.replicaGuid(), entry.globalCounter());
			break;
		}
		default:
			IllegalArgumentException exception = new IllegalArgumentException("Unsupported operation: " + key);
			log.failure(payload, key, payload, exception);
			throw exception;
		}
	}
}
