/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.eas.backend.bm.mail.loader;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;

import com.google.common.io.ByteSource;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import net.bluemind.core.api.Stream;
import net.bluemind.eas.dto.base.AirSyncBaseRequest.BodyPreference;
import net.bluemind.eas.dto.base.AirSyncBaseResponse.Body;
import net.bluemind.eas.dto.base.AirSyncBaseResponse.NativeBodyType;
import net.bluemind.eas.dto.base.BodyOptions;
import net.bluemind.eas.dto.base.BodyType;
import net.bluemind.eas.dto.base.DisposableByteSource;

public class MimeBodyAccumulator implements IBodyAccumulator {

	private final BodyType needed;

	Body body;

	public MimeBodyAccumulator(BodyOptions options) {
		BodyPreference bp = options.bodyPrefs.get(0);
		needed = bp.type;
	}

	public void consumeMime(Stream stream) {
		ByteBuf partContent = SyncStreamDownload.read(stream).orTimeout(15, TimeUnit.SECONDS).join();
		this.body = new Body();
		body.type = needed;
		body.data = DisposableByteSource.wrap(new ByteSource() {

			@Override
			public InputStream openStream() throws IOException {
				return new ByteBufInputStream(partContent.duplicate());
			}
		});
	}

	public net.bluemind.eas.dto.base.AirSyncBaseResponse.Body body() {
		return body;
	}

	public NativeBodyType nativeBodyType() {
		switch (needed) {
		case PlainText:
			return NativeBodyType.PLAIN_TEXT;
		case RTF:
			return NativeBodyType.RTF;
		default:
		case MIME:
		case HTML:
			return NativeBodyType.HTML;
		}
	}

	public BodyType getBodyType() {
		return needed;
	}
}
