package net.bluemind.domain.service;

import java.sql.SQLException;

import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.container.model.BaseContainerDescriptor;
import net.bluemind.core.container.model.Container;
import net.bluemind.core.container.model.DataLocation;
import net.bluemind.core.container.repository.IContainerStore;
import net.bluemind.core.container.service.internal.ItemValueAuditLogService;
import net.bluemind.core.rest.BmContext;
import net.bluemind.domain.api.Domain;
import net.bluemind.domain.service.internal.DomainsService;
import net.bluemind.repository.provider.RepositoryProvider;

public abstract class DomainsServiceCommonFactory {

	protected DomainsService instanceImpl(BmContext context) throws ServerFault {

		IContainerStore containerStore = RepositoryProvider.instance(IContainerStore.class, context,
				DataLocation.directory());
		Container container = null;
		try {
			container = containerStore.get(DomainsContainerIdentifier.getIdentifier());
		} catch (SQLException e) {
			throw ServerFault.sqlFault(e);
		}
		if (container == null) {
			throw new ServerFault("container " + DomainsContainerIdentifier.getIdentifier() + " not found");
		}

		BaseContainerDescriptor descriptor = BaseContainerDescriptor.create(container.uid, container.name,
				container.owner, container.type, container.domainUid, container.defaultContainer);
		descriptor.internalId = container.id;
		ItemValueAuditLogService<Domain> logService = new ItemValueAuditLogService<>(context, descriptor);

		return new DomainsService(context, container, logService);
	}
}
