<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * JobQuery.
 */
class JobQuery  {

  /*
   * @type String
   */
  public $jobId;

  /*
   * @type Set
   */
  public $statuses;

  /*
   * @type String
   */
  public $domain;

  /*
   * Constructor
   */
  public function __construct() {
    $this->jobId = "";
    $this->statuses = array();
    $this->domain = "";
  }

  public function toMap() {
    $data = array(    
        "jobId" => empty($this->jobId) ? null : $this->jobId,    
        "statuses" => empty($this->statuses) ? null : $this->statuses,    
        "domain" => empty($this->domain) ? null : $this->domain);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
