/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2024
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.cli.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DOMUtils {

	private static ErrorHandler errorHandler;

	static {
		errorHandler = new ErrorHandler() {
			private Logger logger = LoggerFactory.getLogger(getClass());

			@Override
			public void warning(SAXParseException arg0) throws SAXException {
				logger.warn(arg0.getMessage());
			}

			@Override
			public void fatalError(SAXParseException arg0) throws SAXException {
				logger.error(arg0.getMessage(), arg0);
			}

			@Override
			public void error(SAXParseException arg0) throws SAXException {
				logger.error(arg0.getMessage(), arg0);
			}
		};
	}

	public static Document parseXml(String xml) throws SAXException, IOException, ParserConfigurationException {
		DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
		documentBuilder.setErrorHandler(errorHandler);
		return documentBuilder.parse(new ByteArrayInputStream(xml.getBytes()));
	}
}
