package net.bluemind.todolist.api;
import net.bluemind.core.api.BMPromiseApi;
import java.util.concurrent.CompletableFuture;

@BMPromiseApi(net.bluemind.todolist.api.ITodoListAsync.class)
public interface ITodoListPromise  {

	CompletableFuture<java.util.List<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>>> all();

	CompletableFuture<java.util.List<java.lang.String>> allUids();

	CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<java.lang.String>> changeset(java.lang.Long since);

	CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<java.lang.Long>> changesetById(java.lang.Long since);

	CompletableFuture<Void> copy(java.util.List<java.lang.String> uids, java.lang.String destContainerUid);

	CompletableFuture<net.bluemind.core.container.api.Count> count(net.bluemind.core.container.model.ItemFlagFilter arg0);

	CompletableFuture<Void> create(java.lang.String uid, net.bluemind.todolist.api.VTodo todo);

	CompletableFuture<net.bluemind.core.container.api.Ack> createById(long id, net.bluemind.todolist.api.VTodo arg1);

	CompletableFuture<Void> delete(java.lang.String uid);

	CompletableFuture<Void> deleteById(long id);

	CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>> filteredChangesetById(java.lang.Long since, net.bluemind.core.container.model.ItemFlagFilter arg1);

	CompletableFuture<java.util.List<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>>> getByIcsUid(java.lang.String uid);

	CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>> getComplete(java.lang.String uid);

	CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>> getCompleteById(long id);

	CompletableFuture<Long> getVersion();

	CompletableFuture<net.bluemind.core.container.model.ItemChangelog> itemChangelog(java.lang.String uid, java.lang.Long arg1);

	CompletableFuture<Void> move(java.util.List<java.lang.String> uids, java.lang.String destContainerUid);

	CompletableFuture<Void> multipleDeleteById(java.util.List<java.lang.Long> arg0, java.lang.Boolean bypassDeletedItems);

	CompletableFuture<java.util.List<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>>> multipleGet(java.util.List<java.lang.String> uids);

	CompletableFuture<java.util.List<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>>> multipleGetById(java.util.List<java.lang.Long> arg0);

	CompletableFuture<net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>>> multipleGetByRange(net.bluemind.todolist.api.VTodoRange range);

	CompletableFuture<net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>>> multipleGetWithOffset(java.lang.Integer from, java.lang.Integer size);

	CompletableFuture<Void> reset();

	CompletableFuture<net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>>> search(net.bluemind.todolist.api.VTodoQuery query);

	CompletableFuture<java.util.List<java.lang.Long>> sortedIds(net.bluemind.core.container.model.SortDescriptor arg0);

	CompletableFuture<java.util.List<java.lang.String>> sortedUids(net.bluemind.core.container.model.SortDescriptor arg0);

	CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<java.lang.String>> sync(java.lang.Long since, net.bluemind.todolist.api.VTodoChanges changes);

	CompletableFuture<Void> update(java.lang.String uid, net.bluemind.todolist.api.VTodo todo);

	CompletableFuture<net.bluemind.core.container.api.Ack> updateById(long id, net.bluemind.todolist.api.VTodo arg1);

	CompletableFuture<net.bluemind.core.container.model.ContainerUpdatesResult> updates(net.bluemind.todolist.api.VTodoChanges changes);

}