/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.todolist.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONValue;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;

public class TodoListGwtEndpoint implements net.bluemind.todolist.api.ITodoListAsync {

	private String baseUri;

	private String sessionId;

	private String root = "/api";

	public TodoListGwtEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/todolist/{containerUid}";
		this.sessionId = sessionId;
	
		uri_ = uri_.replace("{containerUid}", URL.encodePathSegment(pathVars[0]));
		
		baseUri = uri_;
	}

	public TodoListGwtEndpoint withRoot(String root) {
		this.root = root;
		return this;
	}

	@Override
	public void all(final AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>>> handler) {
		String postUri = "";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<List<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>>>(handler) {
			@Override
			protected List<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemValueGwtSerDer<>(new net.bluemind.todolist.api.gwt.serder.VTodoGwtSerDer())).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void allUids(final AsyncHandler<List<String>> handler) {
		String postUri = "/_all";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<List<String>>(handler) {
			@Override
			protected List<String> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void changeset(Long since, final AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<String>> handler) {
		String postUri = "/_changeset";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		queryParams += "&since=" + URL.encodeQueryString(""+since);
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.container.model.ContainerChangeset<String>>(handler) {
			@Override
			protected net.bluemind.core.container.model.ContainerChangeset<String> handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.model.gwt.serder.ContainerChangesetGwtSerDer<>(GwtSerDerUtils.STRING).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void changesetById(Long since, final AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<Long>> handler) {
		String postUri = "/_changesetById";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		queryParams += "&since=" + URL.encodeQueryString(""+since);
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.container.model.ContainerChangeset<Long>>(handler) {
			@Override
			protected net.bluemind.core.container.model.ContainerChangeset<Long> handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.model.gwt.serder.ContainerChangesetGwtSerDer<>(GwtSerDerUtils.LONG).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void copy(List<String> uids, String destContainerUid, final AsyncHandler<Void> handler) {
		String postUri = "/_copy/{destContainerUid}";

		postUri = postUri.replace("{destContainerUid}", URL.encodePathSegment(""+destContainerUid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( uids);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void count(net.bluemind.core.container.model.ItemFlagFilter arg0, final AsyncHandler<net.bluemind.core.container.api.Count> handler) {
		String postUri = "/_count";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new net.bluemind.core.container.model.gwt.serder.ItemFlagFilterGwtSerDer().serialize( arg0);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.container.api.Count>(handler) {
			@Override
			protected net.bluemind.core.container.api.Count handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.api.gwt.serder.CountGwtSerDer().deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void create(String uid, net.bluemind.todolist.api.VTodo todo, final AsyncHandler<Void> handler) {
		String postUri = "/{uid}";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.PUT, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new net.bluemind.todolist.api.gwt.serder.VTodoGwtSerDer().serialize( todo);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void createById(long id, net.bluemind.todolist.api.VTodo arg1, final AsyncHandler<net.bluemind.core.container.api.Ack> handler) {
		String postUri = "/id/{id}";

		postUri = postUri.replace("{id}", URL.encodePathSegment(""+id));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.PUT, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new net.bluemind.todolist.api.gwt.serder.VTodoGwtSerDer().serialize( arg1);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.container.api.Ack>(handler) {
			@Override
			protected net.bluemind.core.container.api.Ack handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.api.gwt.serder.AckGwtSerDer().deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void delete(String uid, final AsyncHandler<Void> handler) {
		String postUri = "/{uid}";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.DELETE, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void deleteById(long id, final AsyncHandler<Void> handler) {
		String postUri = "/id/{id}";

		postUri = postUri.replace("{id}", URL.encodePathSegment(""+id));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.DELETE, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void filteredChangesetById(Long since, net.bluemind.core.container.model.ItemFlagFilter arg1, final AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>> handler) {
		String postUri = "/_filteredChangesetById";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		queryParams += "&since=" + URL.encodeQueryString(""+since);
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new net.bluemind.core.container.model.gwt.serder.ItemFlagFilterGwtSerDer().serialize( arg1);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>>(handler) {
			@Override
			protected net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion> handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.model.gwt.serder.ContainerChangesetGwtSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemVersionGwtSerDer()).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void getByIcsUid(String uid, final AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>>> handler) {
		String postUri = "/_icsuid/{uid}";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<List<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>>>(handler) {
			@Override
			protected List<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemValueGwtSerDer<>(new net.bluemind.todolist.api.gwt.serder.VTodoGwtSerDer())).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void getComplete(String uid, final AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>> handler) {
		String postUri = "/{uid}/complete";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>>(handler) {
			@Override
			protected net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo> handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.model.gwt.serder.ItemValueGwtSerDer<>(new net.bluemind.todolist.api.gwt.serder.VTodoGwtSerDer()).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void getCompleteById(long id, final AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>> handler) {
		String postUri = "/{id}/completeById";

		postUri = postUri.replace("{id}", URL.encodePathSegment(""+id));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>>(handler) {
			@Override
			protected net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo> handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.model.gwt.serder.ItemValueGwtSerDer<>(new net.bluemind.todolist.api.gwt.serder.VTodoGwtSerDer()).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void getVersion(final AsyncHandler<Long> handler) {
		String postUri = "/_version";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Long>(handler) {
			@Override
			protected Long handleResponse(
							JSONValue jsonValue) {
				return GwtSerDerUtils.LONG.deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void itemChangelog(String uid, Long arg1, final AsyncHandler<net.bluemind.core.container.model.ItemChangelog> handler) {
		String postUri = "/{uid}/_itemchangelog";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = GwtSerDerUtils.LONG.serialize( arg1);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.container.model.ItemChangelog>(handler) {
			@Override
			protected net.bluemind.core.container.model.ItemChangelog handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.model.gwt.serder.ItemChangelogGwtSerDer().deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void move(List<String> uids, String destContainerUid, final AsyncHandler<Void> handler) {
		String postUri = "/_move/{destContainerUid}";

		postUri = postUri.replace("{destContainerUid}", URL.encodePathSegment(""+destContainerUid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( uids);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void multipleDeleteById(List<Long> arg0, Boolean bypassDeletedItems, final AsyncHandler<Void> handler) {
		String postUri = "/_multipleDelete";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		queryParams += "&bypassDeletedItems=" + URL.encodeQueryString(""+bypassDeletedItems);
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.DELETE, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.LONG).serialize( arg0);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void multipleGet(List<String> uids, final AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>>> handler) {
		String postUri = "/_mget";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( uids);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<List<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>>>(handler) {
			@Override
			protected List<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemValueGwtSerDer<>(new net.bluemind.todolist.api.gwt.serder.VTodoGwtSerDer())).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void multipleGetById(List<Long> arg0, final AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>>> handler) {
		String postUri = "/_mgetById";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.LONG).serialize( arg0);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<List<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>>>(handler) {
			@Override
			protected List<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemValueGwtSerDer<>(new net.bluemind.todolist.api.gwt.serder.VTodoGwtSerDer())).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void multipleGetByRange(net.bluemind.todolist.api.VTodoRange range, final AsyncHandler<net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>>> handler) {
		String postUri = "/_mget_range";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new net.bluemind.todolist.api.gwt.serder.VTodoRangeGwtSerDer().serialize( range);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>>>(handler) {
			@Override
			protected net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>> handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.api.gwt.serder.ListResultGwtSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemValueGwtSerDer<>(new net.bluemind.todolist.api.gwt.serder.VTodoGwtSerDer())).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void multipleGetWithOffset(Integer from, Integer size, final AsyncHandler<net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>>> handler) {
		String postUri = "/_mget_offset";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		queryParams += "&from=" + URL.encodeQueryString(""+from);
		queryParams += "&size=" + URL.encodeQueryString(""+size);
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>>>(handler) {
			@Override
			protected net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>> handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.api.gwt.serder.ListResultGwtSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemValueGwtSerDer<>(new net.bluemind.todolist.api.gwt.serder.VTodoGwtSerDer())).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void reset(final AsyncHandler<Void> handler) {
		String postUri = "/_reset";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void search(net.bluemind.todolist.api.VTodoQuery query, final AsyncHandler<net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>>> handler) {
		String postUri = "/_search";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new net.bluemind.todolist.api.gwt.serder.VTodoQueryGwtSerDer().serialize( query);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>>>(handler) {
			@Override
			protected net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.todolist.api.VTodo>> handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.api.gwt.serder.ListResultGwtSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemValueGwtSerDer<>(new net.bluemind.todolist.api.gwt.serder.VTodoGwtSerDer())).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void sortedIds(net.bluemind.core.container.model.SortDescriptor arg0, final AsyncHandler<List<Long>> handler) {
		String postUri = "/_sorted";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new net.bluemind.core.container.model.gwt.serder.SortDescriptorGwtSerDer().serialize( arg0);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<List<Long>>(handler) {
			@Override
			protected List<Long> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.LONG).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void sortedUids(net.bluemind.core.container.model.SortDescriptor arg0, final AsyncHandler<List<String>> handler) {
		String postUri = "/_sorteduids";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new net.bluemind.core.container.model.gwt.serder.SortDescriptorGwtSerDer().serialize( arg0);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<List<String>>(handler) {
			@Override
			protected List<String> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void sync(Long since, net.bluemind.todolist.api.VTodoChanges changes, final AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<String>> handler) {
		String postUri = "/_sync";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		queryParams += "&since=" + URL.encodeQueryString(""+since);
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new net.bluemind.todolist.api.gwt.serder.VTodoChangesGwtSerDer().serialize( changes);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.container.model.ContainerChangeset<String>>(handler) {
			@Override
			protected net.bluemind.core.container.model.ContainerChangeset<String> handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.model.gwt.serder.ContainerChangesetGwtSerDer<>(GwtSerDerUtils.STRING).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void update(String uid, net.bluemind.todolist.api.VTodo todo, final AsyncHandler<Void> handler) {
		String postUri = "/{uid}";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new net.bluemind.todolist.api.gwt.serder.VTodoGwtSerDer().serialize( todo);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void updateById(long id, net.bluemind.todolist.api.VTodo arg1, final AsyncHandler<net.bluemind.core.container.api.Ack> handler) {
		String postUri = "/id/{id}";

		postUri = postUri.replace("{id}", URL.encodePathSegment(""+id));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new net.bluemind.todolist.api.gwt.serder.VTodoGwtSerDer().serialize( arg1);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.container.api.Ack>(handler) {
			@Override
			protected net.bluemind.core.container.api.Ack handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.api.gwt.serder.AckGwtSerDer().deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void updates(net.bluemind.todolist.api.VTodoChanges changes, final AsyncHandler<net.bluemind.core.container.model.ContainerUpdatesResult> handler) {
		String postUri = "/_mupdates";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.PUT, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new net.bluemind.todolist.api.gwt.serder.VTodoChangesGwtSerDer().serialize( changes);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.container.model.ContainerUpdatesResult>(handler) {
			@Override
			protected net.bluemind.core.container.model.ContainerUpdatesResult handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.model.gwt.serder.ContainerUpdatesResultGwtSerDer().deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}

	public net.bluemind.todolist.api.ITodoListPromise promiseApi() {
		return new TodoListEndpointPromise(this);
	}
}
