/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.directory.service.internal.cql;

import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.container.model.Container;
import net.bluemind.core.container.model.ContainerChangeset;
import net.bluemind.core.container.model.ItemIdentifier;
import net.bluemind.core.container.model.ItemValue;
import net.bluemind.core.rest.BmContext;
import net.bluemind.directory.api.BaseDirEntry.AccountType;
import net.bluemind.directory.api.DirEntry;
import net.bluemind.directory.cql.common.CqlContStoreService;
import net.bluemind.directory.repository.DirEntryNG;
import net.bluemind.directory.service.IInCoreDirectory;
import net.bluemind.domain.api.Domain;
import net.bluemind.domain.api.IDomains;

public class CqlInCoreDirectoryService implements IInCoreDirectory {

	private final CqlContStoreService store;

	public CqlInCoreDirectoryService(BmContext su, Container dirContainer, String domainUid) {
		this.store = new CqlContStoreService(su, dirContainer, getDomain(su, domainUid));
	}

	ItemValue<Domain> getDomain(BmContext ctx, String domainUid) {
		return ctx.provider().instance(IDomains.class).get(domainUid);
	}

	@Override
	public ItemValue<DirEntry> get(String path) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void create(String uid, DirEntry entry) throws ServerFault {
		System.err.println("create(" + uid + ", " + entry + ")");
		store.create(uid, entry.displayName, DirEntryNG.of(entry));
	}

	@Override
	public void create(ItemValue<DirEntry> item) {
		System.err.println("create(" + item + ")");
		store.create(item.item(), DirEntryNG.of(item.value));
	}

	@Override
	public void update(String uid, DirEntry entry) throws ServerFault {
		// TODO Auto-generated method stub

	}

	@Override
	public void update(ItemValue<DirEntry> item) throws ServerFault {
		// TODO Auto-generated method stub

	}

	@Override
	public void delete(String uid, String kind) throws ServerFault {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateAccountType(String uid, AccountType accountType) throws ServerFault {
		// TODO Auto-generated method stub

	}

	@Override
	public ContainerChangeset<ItemIdentifier> fullChangeset() throws ServerFault {
		// TODO Auto-generated method stub
		return null;
	}

}
