/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.system.helper;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;

/**
 * Manage empty file to allow or not pg_dump on upgrade
 */
public class DumpPostgresHelper {
	private static final String BACKUP_WITH_PG_DUMP_FILE = "/var/backups/bluemind/with.upgrade.pg.dump";

	public static boolean exists() {
		return Files.exists(Path.of(DumpPostgresHelper.BACKUP_WITH_PG_DUMP_FILE));
	}

	public static boolean allowPgDump() throws IOException {
		return new File(BACKUP_WITH_PG_DUMP_FILE).createNewFile();
	}

	public static String fileName() {
		return BACKUP_WITH_PG_DUMP_FILE;
	}

	public static boolean disablePgDump() throws IOException {
		return Files.deleteIfExists(Path.of(BACKUP_WITH_PG_DUMP_FILE));
	}

}
