/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2023
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.keydb.sessiondata;

import java.util.concurrent.TimeUnit;

public class CodeVerifierCache {
	public static final String DATA_VALUE_HOLDER = "oid:codeverifier:";

	private CodeVerifierCache() {
	}

	private static String valueHolder(String key) {
		return DATA_VALUE_HOLDER + key;
	}

	public static String getAndRemove(String key) {
		return SessionDataStore.get().getCommands().getdel(valueHolder(key));
	}

	public static void put(String key, String codeVerifier) {
		SessionDataStore.get().getCommands().setex(valueHolder(key), TimeUnit.MINUTES.toSeconds(10), codeVerifier);
	}
}
