package net.bluemind.core.container.service;

import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.container.api.IChangesetCleanup;
import net.bluemind.core.container.model.DataLocation;
import net.bluemind.core.container.service.internal.ChangesetCleanupService;
import net.bluemind.core.rest.BmContext;
import net.bluemind.core.rest.ServerSideServiceProvider;

public class ChangesetCleanupServiceFactory
		implements ServerSideServiceProvider.IServerSideServiceFactory<IChangesetCleanup> {

	@Override
	public Class<IChangesetCleanup> factoryClass() {
		return IChangesetCleanup.class;
	}

	@Override
	public IChangesetCleanup instance(BmContext context, String... params) {
		if (params == null || params.length < 1) {
			throw new ServerFault("wrong number of instance parameters");
		}

		String serverUid = params[0];
		return new ChangesetCleanupService(context, DataLocation.of(serverUid));
	}

}
