/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.authentication.api.gwt.endpoint;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.http.client.URL;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.lang.Long;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.api.Stream;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;

public class UserAccessTokenSockJsEndpoint implements net.bluemind.authentication.api.IUserAccessTokenAsync {

	private String rootUri = "/api";

	private String baseUri;

    private String sessionId;

	public UserAccessTokenSockJsEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/auth/access_token";
		this.sessionId = sessionId;
	

		baseUri = uri_;
	}

	public UserAccessTokenSockJsEndpoint withRoot(String root) {
		this.rootUri = root;
		return this;
	}

	@Override
	public void authCodeReceived(String state, String code, final AsyncHandler<net.bluemind.authentication.api.AccessTokenInfo> handler) {
		String postUri = "/_auth";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		params.put("state", URL.encodeQueryString(""+state));
		params.put("code", URL.encodeQueryString(""+code));
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.authentication.api.AccessTokenInfo>(handler) {
					@Override
			protected net.bluemind.authentication.api.AccessTokenInfo handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.authentication.api.gwt.serder.AccessTokenInfoGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void getTokenInfo(String external_system, String baseUrl, final AsyncHandler<net.bluemind.authentication.api.AccessTokenInfo> handler) {
		String postUri = "/_info";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		params.put("external_system", URL.encodeQueryString(""+external_system));
		params.put("baseUrl", URL.encodeQueryString(""+baseUrl));
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.authentication.api.AccessTokenInfo>(handler) {
					@Override
			protected net.bluemind.authentication.api.AccessTokenInfo handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.authentication.api.gwt.serder.AccessTokenInfoGwtSerDer().deserialize( jsonValue );
			}
		});

	}

	public net.bluemind.authentication.api.IUserAccessTokenPromise promiseApi() {
		return new UserAccessTokenEndpointPromise(this);
	}

}
