package net.bluemind.central.reverse.proxy.vertx.impl;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

import io.vertx.core.Future;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.SocketAddressImpl;
import net.bluemind.central.reverse.proxy.model.client.ProxyInfoStoreClient;
import net.bluemind.central.reverse.proxy.vertx.Auth;

public class DownstreamSelector implements Function<HttpServerRequest, Future<SocketAddress>> {
	private final ProxyInfoStoreClient storeClient;
	private final Map<String, SocketAddress> ipMap = new ConcurrentHashMap<>(8);

	public DownstreamSelector(ProxyInfoStoreClient storeClient) {
		this.storeClient = storeClient;
	}

	@Override
	public Future<SocketAddress> apply(HttpServerRequest req) {
		return selectDownstream(req) //
				.map(auth -> storeClient.ip(auth.login()).recover(t -> storeClient.anyIp())) //
				.orElseGet(storeClient::anyIp) //
				.map(ip -> ipMap.computeIfAbsent(ip, v -> new SocketAddressImpl(443, ip)));
	}

	public Optional<Auth> selectDownstream(HttpServerRequest request) {
		return Optional.ofNullable(request.getCookie(CRPInterceptor.COOKIENAME)) //
				.map(Cookie::getValue) //
				.flatMap(Optional::ofNullable) //
				.map(Auth::new);
	}

}
