/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.container.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class ContainerHierarchyNodeGwtSerDer implements GwtSerDer<net.bluemind.core.container.api.ContainerHierarchyNode> {

	public ContainerHierarchyNodeGwtSerDer( ) {
	}

	@Override
	public net.bluemind.core.container.api.ContainerHierarchyNode deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.core.container.api.ContainerHierarchyNode ret = new net.bluemind.core.container.api.ContainerHierarchyNode();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.core.container.api.ContainerHierarchyNode ret, JSONObject json) {
		JSONValue containerUidJSON = json.get("containerUid");
		ret.containerUid =  GwtSerDerUtils.STRING.deserialize(containerUidJSON);
		JSONValue containerTypeJSON = json.get("containerType");
		ret.containerType =  GwtSerDerUtils.STRING.deserialize(containerTypeJSON);
		JSONValue nameJSON = json.get("name");
		ret.name =  GwtSerDerUtils.STRING.deserialize(nameJSON);
		JSONValue deletedJSON = json.get("deleted");
		ret.deleted =  GwtSerDerUtils.BOOLEAN.deserialize(deletedJSON);
	}

	public void deserializeTo(net.bluemind.core.container.api.ContainerHierarchyNode ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("containerUid")) {
			JSONValue containerUidJSON = json.get("containerUid");
			ret.containerUid =  GwtSerDerUtils.STRING.deserialize(containerUidJSON);
		}
		if (!childPropertiesToIgnore.contains("containerType")) {
			JSONValue containerTypeJSON = json.get("containerType");
			ret.containerType =  GwtSerDerUtils.STRING.deserialize(containerTypeJSON);
		}
		if (!childPropertiesToIgnore.contains("name")) {
			JSONValue nameJSON = json.get("name");
			ret.name =  GwtSerDerUtils.STRING.deserialize(nameJSON);
		}
		if (!childPropertiesToIgnore.contains("deleted")) {
			JSONValue deletedJSON = json.get("deleted");
			ret.deleted =  GwtSerDerUtils.BOOLEAN.deserialize(deletedJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.core.container.api.ContainerHierarchyNode o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.core.container.api.ContainerHierarchyNode o, JSONObject ret) {

		ret.put("containerUid",  GwtSerDerUtils.STRING.serialize( o.containerUid ));
		ret.put("containerType",  GwtSerDerUtils.STRING.serialize( o.containerType ));
		ret.put("name",  GwtSerDerUtils.STRING.serialize( o.name ));
		ret.put("deleted",  GwtSerDerUtils.BOOLEAN.serialize( o.deleted ));
	}

	public void serializeTo(net.bluemind.core.container.api.ContainerHierarchyNode o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("containerUid")) {
			ret.put("containerUid",  GwtSerDerUtils.STRING.serialize( o.containerUid ));
		}
		if (!childPropertiesToIgnore.contains("containerType")) {
			ret.put("containerType",  GwtSerDerUtils.STRING.serialize( o.containerType ));
		}
		if (!childPropertiesToIgnore.contains("name")) {
			ret.put("name",  GwtSerDerUtils.STRING.serialize( o.name ));
		}
		if (!childPropertiesToIgnore.contains("deleted")) {
			ret.put("deleted",  GwtSerDerUtils.BOOLEAN.serialize( o.deleted ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}