/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2025
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.ui.adminconsole.directory.sharedmailbox.l10n;

import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.Messages;

public interface SharedMailboxConstants extends Messages {

	public static final SharedMailboxConstants INST = GWT.create(SharedMailboxConstants.class);

	String editTitle(String name);

	String name();

	String generalTab();

	String accountName();
	
	String displayName();

	String direction();

	String desc();

	String mail();

	String forward();

	String vacation();

	String mailTab();

	String contactTab();

	String enableMail();

	String delegation();

	String delegationTarget();

	String groups();

	String editGroupMembership();

	String profile();

	String archive();

	String quota();

	String changePicture();

	String calPermsTab();

	String mboxPermsTab();

	String identity();

	String type();

	String customEmail();

	String outOfBMEmail();

	String extMailDesc();

	String routingInternal();

	String routingExternal();

	String routingNone();

	String hideFromGal();

	String storagePolicyTab();

	String mailSettings();

	String calendarSettings();

	String contactsSettings();

	String clientSettings();

	String maintenanceTab();

	String mailboxReindex();

	String clearLocalData();

	String newSharedMailbox();

	String roles();

	String mailboxSharing();

	String validateSharedMailbox();

	String checkAndRepair();

	String execute();

	String accountType();

	String accountTypeFull();
}
