/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2025
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.ui.adminconsole.directory.sharedmailbox;

import java.util.Arrays;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.shared.GWT;
import com.google.gwt.json.client.JSONObject;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.JsMapStringJsObject;
import net.bluemind.core.container.model.gwt.js.JsItemValue;
import net.bluemind.directory.api.gwt.js.JsBaseDirEntryAccountType;
import net.bluemind.domain.api.gwt.js.JsDomain;
import net.bluemind.gwtconsoleapp.base.editor.ModelHandler;
import net.bluemind.gwtconsoleapp.base.editor.gwt.GwtModelHandler;
import net.bluemind.gwtconsoleapp.base.editor.gwt.IGwtDelegateFactory;
import net.bluemind.gwtconsoleapp.base.editor.gwt.IGwtModelHandler;
import net.bluemind.gwtconsoleapp.base.handler.DefaultAsyncHandler;
import net.bluemind.ui.adminconsole.base.DomainsHolder;
import net.bluemind.ui.common.client.errors.ErrorCodeTexts;
import net.bluemind.ui.common.client.forms.Ajax;
import net.bluemind.user.api.gwt.endpoint.UserGwtEndpoint;
import net.bluemind.user.api.gwt.js.JsUser;
import net.bluemind.user.api.gwt.serder.UserGwtSerDer;

public class QCreateSharedMailboxModelHandler implements IGwtModelHandler {

	public static final String TYPE = "bm.ac.QCreateSharedMailboxModelHandler";

	protected QCreateSharedMailboxModelHandler() {
	}

	public static void registerType() {
		GwtModelHandler.register(TYPE, new IGwtDelegateFactory<IGwtModelHandler, ModelHandler>() {

			@Override
			public IGwtModelHandler create(ModelHandler modelHandler) {
				return new QCreateSharedMailboxModelHandler();
			}
		});
		GWT.log("bm.ac.QCreateSharedMailboxModelHandler registred");
	}

	@Override
	public void load(JavaScriptObject model, AsyncHandler<Void> handler) {

		GWT.log("initialize QCreateSharedMailboxModel");
		JsMapStringJsObject map = model.cast();

		if (DomainsHolder.get().getSelectedDomain() != null) {
			map.putString("domainUid", DomainsHolder.get().getSelectedDomain().uid);
		}
		JsUser sharedMailbox = JsUser.create();
		sharedMailbox.setLoginCaps(false);
		map.put("sharedMailbox", sharedMailbox);
		handler.success(null);

	}

	@Override
	public void save(JavaScriptObject model, final AsyncHandler<Void> handler) {
		final JsMapStringJsObject map = model.cast();

		JsItemValue<JsDomain> domain = map.get("domain").cast();
		if (domain == null || domain.getValue().getGlobal()) {
			handler.failure(new RuntimeException(ErrorCodeTexts.INST.getString("NOT_IN_GLOBAL_DOMAIN")));
			return;
		}
		final String domainUid = map.getString("domainUid");
		JsUser sharedMailbox = map.get("sharedMailbox").cast();
		sharedMailbox.setArchived(false);
		sharedMailbox.setSystem(false);
		sharedMailbox.setLoginCaps(false);

		String accountType = map.getString("accountType");
		if (accountType == null || accountType.isEmpty() || !"FULL".equals(accountType)) {
			sharedMailbox.setAccountType(JsBaseDirEntryAccountType.FULL());
		}

		UserGwtEndpoint users = new UserGwtEndpoint(Ajax.TOKEN.getSessionId(), domainUid);
		final String uid = net.bluemind.ui.common.client.forms.tag.UUID.uuid();
		map.putString("dirEntryId", uid);
		users.create(uid, new UserGwtSerDer().deserialize(new JSONObject(sharedMailbox)),
				new DefaultAsyncHandler<Void>(handler) {
					@Override
					public void success(Void value) {
						handler.success(null);
						return;
					}
				});
	}

}
