/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.directory.cql.store.factories;

import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.rest.BmContext;
import net.bluemind.cql.persistence.CqlRepositoryFactory;
import net.bluemind.directory.cql.store.CqlMailIdentityStore;
import net.bluemind.mailbox.repository.IMailboxIdentityStore;
import net.bluemind.repository.provider.IStandaloneFactory;

public class IdentityStoreFactory extends CqlRepositoryFactory<IMailboxIdentityStore>
		implements IStandaloneFactory<IMailboxIdentityStore> {

	@Override
	public Class<IMailboxIdentityStore> factoryClass() {
		return IMailboxIdentityStore.class;
	}

	@Override
	public IMailboxIdentityStore instance(BmContext context) throws ServerFault {
		return new CqlMailIdentityStore();
	}

}
