/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.directory.cql.store;

import java.sql.SQLException;
import java.util.Set;

import com.datastax.oss.driver.api.core.CqlSession;

import net.bluemind.core.container.model.Container;
import net.bluemind.core.container.model.Item;
import net.bluemind.cql.persistence.CqlAbstractStore;
import net.bluemind.role.repository.IRoleStore;

public class CqlRoleStore extends CqlAbstractStore implements IRoleStore {

	private final long contId;

	public CqlRoleStore(CqlSession s, Container c) {
		super(s);
		this.contId = c.id;
	}

	@Override
	public void set(Item it, Set<String> roles) throws SQLException {
		voidCql("update t_dir_entry set roles=? where container_id=? AND item_id=?", roles, contId, it.id);
	}

	@Override
	public Set<String> get(Item it) throws SQLException {
		return unique("select roles from t_dir_entry where container_id=? AND item_id=?",
				r -> r.getSet(0, String.class), voidPop(), contId, it.id);
	}

}
