/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.dataprotect.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class DPErrorGwtSerDer implements GwtSerDer<net.bluemind.dataprotect.api.DPError> {

	public DPErrorGwtSerDer( ) {
	}

	@Override
	public net.bluemind.dataprotect.api.DPError deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.dataprotect.api.DPError ret = new net.bluemind.dataprotect.api.DPError();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.dataprotect.api.DPError ret, JSONObject json) {
		JSONValue messageJSON = json.get("message");
		ret.message =  GwtSerDerUtils.STRING.deserialize(messageJSON);
		JSONValue uidJSON = json.get("uid");
		ret.uid =  GwtSerDerUtils.STRING.deserialize(uidJSON);
		JSONValue typeJSON = json.get("type");
		ret.type =  new net.bluemind.dataprotect.api.gwt.serder.DPErrorRestoreTypeGwtSerDer().deserialize(typeJSON);
		JSONValue kindJSON = json.get("kind");
		ret.kind =  new net.bluemind.dataprotect.api.gwt.serder.DPErrorDPKindGwtSerDer().deserialize(kindJSON);
		JSONValue errorCodeJSON = json.get("errorCode");
		ret.errorCode =  new net.bluemind.core.api.fault.gwt.serder.ErrorCodeGwtSerDer().deserialize(errorCodeJSON);
	}

	public void deserializeTo(net.bluemind.dataprotect.api.DPError ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("message")) {
			JSONValue messageJSON = json.get("message");
			ret.message =  GwtSerDerUtils.STRING.deserialize(messageJSON);
		}
		if (!childPropertiesToIgnore.contains("uid")) {
			JSONValue uidJSON = json.get("uid");
			ret.uid =  GwtSerDerUtils.STRING.deserialize(uidJSON);
		}
		if (!childPropertiesToIgnore.contains("type")) {
			JSONValue typeJSON = json.get("type");
			ret.type =  new net.bluemind.dataprotect.api.gwt.serder.DPErrorRestoreTypeGwtSerDer().deserialize(typeJSON);
		}
		if (!childPropertiesToIgnore.contains("kind")) {
			JSONValue kindJSON = json.get("kind");
			ret.kind =  new net.bluemind.dataprotect.api.gwt.serder.DPErrorDPKindGwtSerDer().deserialize(kindJSON);
		}
		if (!childPropertiesToIgnore.contains("errorCode")) {
			JSONValue errorCodeJSON = json.get("errorCode");
			ret.errorCode =  new net.bluemind.core.api.fault.gwt.serder.ErrorCodeGwtSerDer().deserialize(errorCodeJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.dataprotect.api.DPError o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.dataprotect.api.DPError o, JSONObject ret) {

		ret.put("message",  GwtSerDerUtils.STRING.serialize( o.message ));
		ret.put("uid",  GwtSerDerUtils.STRING.serialize( o.uid ));
		ret.put("type",  new net.bluemind.dataprotect.api.gwt.serder.DPErrorRestoreTypeGwtSerDer().serialize( o.type ));
		ret.put("kind",  new net.bluemind.dataprotect.api.gwt.serder.DPErrorDPKindGwtSerDer().serialize( o.kind ));
		ret.put("errorCode",  new net.bluemind.core.api.fault.gwt.serder.ErrorCodeGwtSerDer().serialize( o.errorCode ));
	}

	public void serializeTo(net.bluemind.dataprotect.api.DPError o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("message")) {
			ret.put("message",  GwtSerDerUtils.STRING.serialize( o.message ));
		}
		if (!childPropertiesToIgnore.contains("uid")) {
			ret.put("uid",  GwtSerDerUtils.STRING.serialize( o.uid ));
		}
		if (!childPropertiesToIgnore.contains("type")) {
			ret.put("type",  new net.bluemind.dataprotect.api.gwt.serder.DPErrorRestoreTypeGwtSerDer().serialize( o.type ));
		}
		if (!childPropertiesToIgnore.contains("kind")) {
			ret.put("kind",  new net.bluemind.dataprotect.api.gwt.serder.DPErrorDPKindGwtSerDer().serialize( o.kind ));
		}
		if (!childPropertiesToIgnore.contains("errorCode")) {
			ret.put("errorCode",  new net.bluemind.core.api.fault.gwt.serder.ErrorCodeGwtSerDer().serialize( o.errorCode ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}