/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.dataprotect.api.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsWorkerDataType extends JavaScriptObject {

	protected JsWorkerDataType() {}

   public final native String value() 
   /*-{
   	return this;
   }-*/;

	public static final native JsWorkerDataType PG()
	/*-{
		return "PG";
	}-*/;

	public static final native JsWorkerDataType DIRECTORY_LEGACY()
	/*-{
		return "DIRECTORY_LEGACY";
	}-*/;

	public static final native JsWorkerDataType DIRECTORY()
	/*-{
		return "DIRECTORY";
	}-*/;

	public static final native JsWorkerDataType NOTES()
	/*-{
		return "NOTES";
	}-*/;

	public static final native JsWorkerDataType CONFIG()
	/*-{
		return "CONFIG";
	}-*/;

	public static final native JsWorkerDataType CALENDAR()
	/*-{
		return "CALENDAR";
	}-*/;

	public static final native JsWorkerDataType ADDRESSBOOK()
	/*-{
		return "ADDRESSBOOK";
	}-*/;

	public static final native JsWorkerDataType TODOLIST()
	/*-{
		return "TODOLIST";
	}-*/;

	public static final native JsWorkerDataType SDS_SPOOL()
	/*-{
		return "SDS_SPOOL";
	}-*/;

	public static final native JsWorkerDataType SDS()
	/*-{
		return "SDS";
	}-*/;

	public static final native JsWorkerDataType WEBAPPDATA()
	/*-{
		return "WEBAPPDATA";
	}-*/;

	public static final native JsWorkerDataType ELASTICSEARCH()
	/*-{
		return "ELASTICSEARCH";
	}-*/;

	public static final native JsWorkerDataType FILEHOSTING()
	/*-{
		return "FILEHOSTING";
	}-*/;

	public static final JsWorkerDataType create(net.bluemind.dataprotect.api.WorkerDataType value) {
		if (value == null) {
			return null;
		} else {
			switch (value) {
			case PG:
				return PG();
			case DIRECTORY_LEGACY:
				return DIRECTORY_LEGACY();
			case DIRECTORY:
				return DIRECTORY();
			case NOTES:
				return NOTES();
			case CONFIG:
				return CONFIG();
			case CALENDAR:
				return CALENDAR();
			case ADDRESSBOOK:
				return ADDRESSBOOK();
			case TODOLIST:
				return TODOLIST();
			case SDS_SPOOL:
				return SDS_SPOOL();
			case SDS:
				return SDS();
			case WEBAPPDATA:
				return WEBAPPDATA();
			case ELASTICSEARCH:
				return ELASTICSEARCH();
			case FILEHOSTING:
				return FILEHOSTING();
			default:
				return null;
			}
		}
	}
}