/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.addressbook.ldap.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class LdapParametersGwtSerDer implements GwtSerDer<net.bluemind.addressbook.ldap.api.LdapParameters> {

	public LdapParametersGwtSerDer( ) {
	}

	@Override
	public net.bluemind.addressbook.ldap.api.LdapParameters deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.addressbook.ldap.api.LdapParameters ret = new net.bluemind.addressbook.ldap.api.LdapParameters();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.addressbook.ldap.api.LdapParameters ret, JSONObject json) {
		JSONValue typeJSON = json.get("type");
		ret.type =  new net.bluemind.addressbook.ldap.api.gwt.serder.LdapParametersDirectoryTypeGwtSerDer().deserialize(typeJSON);
		JSONValue hostnameJSON = json.get("hostname");
		ret.hostname =  GwtSerDerUtils.STRING.deserialize(hostnameJSON);
		JSONValue protocolJSON = json.get("protocol");
		ret.protocol =  GwtSerDerUtils.STRING.deserialize(protocolJSON);
		JSONValue baseDnJSON = json.get("baseDn");
		ret.baseDn =  GwtSerDerUtils.STRING.deserialize(baseDnJSON);
		JSONValue loginDnJSON = json.get("loginDn");
		ret.loginDn =  GwtSerDerUtils.STRING.deserialize(loginDnJSON);
		JSONValue loginPwJSON = json.get("loginPw");
		ret.loginPw =  GwtSerDerUtils.STRING.deserialize(loginPwJSON);
		JSONValue filterJSON = json.get("filter");
		ret.filter =  GwtSerDerUtils.STRING.deserialize(filterJSON);
		JSONValue allCertificateJSON = json.get("allCertificate");
		ret.allCertificate =  GwtSerDerUtils.BOOLEAN.deserialize(allCertificateJSON);
		JSONValue entryUUIDJSON = json.get("entryUUID");
		ret.entryUUID =  GwtSerDerUtils.STRING.deserialize(entryUUIDJSON);
		JSONValue modifyTimeStampAttrJSON = json.get("modifyTimeStampAttr");
		ret.modifyTimeStampAttr =  GwtSerDerUtils.STRING.deserialize(modifyTimeStampAttrJSON);
	}

	public void deserializeTo(net.bluemind.addressbook.ldap.api.LdapParameters ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("type")) {
			JSONValue typeJSON = json.get("type");
			ret.type =  new net.bluemind.addressbook.ldap.api.gwt.serder.LdapParametersDirectoryTypeGwtSerDer().deserialize(typeJSON);
		}
		if (!childPropertiesToIgnore.contains("hostname")) {
			JSONValue hostnameJSON = json.get("hostname");
			ret.hostname =  GwtSerDerUtils.STRING.deserialize(hostnameJSON);
		}
		if (!childPropertiesToIgnore.contains("protocol")) {
			JSONValue protocolJSON = json.get("protocol");
			ret.protocol =  GwtSerDerUtils.STRING.deserialize(protocolJSON);
		}
		if (!childPropertiesToIgnore.contains("baseDn")) {
			JSONValue baseDnJSON = json.get("baseDn");
			ret.baseDn =  GwtSerDerUtils.STRING.deserialize(baseDnJSON);
		}
		if (!childPropertiesToIgnore.contains("loginDn")) {
			JSONValue loginDnJSON = json.get("loginDn");
			ret.loginDn =  GwtSerDerUtils.STRING.deserialize(loginDnJSON);
		}
		if (!childPropertiesToIgnore.contains("loginPw")) {
			JSONValue loginPwJSON = json.get("loginPw");
			ret.loginPw =  GwtSerDerUtils.STRING.deserialize(loginPwJSON);
		}
		if (!childPropertiesToIgnore.contains("filter")) {
			JSONValue filterJSON = json.get("filter");
			ret.filter =  GwtSerDerUtils.STRING.deserialize(filterJSON);
		}
		if (!childPropertiesToIgnore.contains("allCertificate")) {
			JSONValue allCertificateJSON = json.get("allCertificate");
			ret.allCertificate =  GwtSerDerUtils.BOOLEAN.deserialize(allCertificateJSON);
		}
		if (!childPropertiesToIgnore.contains("entryUUID")) {
			JSONValue entryUUIDJSON = json.get("entryUUID");
			ret.entryUUID =  GwtSerDerUtils.STRING.deserialize(entryUUIDJSON);
		}
		if (!childPropertiesToIgnore.contains("modifyTimeStampAttr")) {
			JSONValue modifyTimeStampAttrJSON = json.get("modifyTimeStampAttr");
			ret.modifyTimeStampAttr =  GwtSerDerUtils.STRING.deserialize(modifyTimeStampAttrJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.addressbook.ldap.api.LdapParameters o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.addressbook.ldap.api.LdapParameters o, JSONObject ret) {

		ret.put("type",  new net.bluemind.addressbook.ldap.api.gwt.serder.LdapParametersDirectoryTypeGwtSerDer().serialize( o.type ));
		ret.put("hostname",  GwtSerDerUtils.STRING.serialize( o.hostname ));
		ret.put("protocol",  GwtSerDerUtils.STRING.serialize( o.protocol ));
		ret.put("baseDn",  GwtSerDerUtils.STRING.serialize( o.baseDn ));
		ret.put("loginDn",  GwtSerDerUtils.STRING.serialize( o.loginDn ));
		ret.put("loginPw",  GwtSerDerUtils.STRING.serialize( o.loginPw ));
		ret.put("filter",  GwtSerDerUtils.STRING.serialize( o.filter ));
		ret.put("allCertificate",  GwtSerDerUtils.BOOLEAN.serialize( o.allCertificate ));
		ret.put("entryUUID",  GwtSerDerUtils.STRING.serialize( o.entryUUID ));
		ret.put("modifyTimeStampAttr",  GwtSerDerUtils.STRING.serialize( o.modifyTimeStampAttr ));
	}

	public void serializeTo(net.bluemind.addressbook.ldap.api.LdapParameters o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("type")) {
			ret.put("type",  new net.bluemind.addressbook.ldap.api.gwt.serder.LdapParametersDirectoryTypeGwtSerDer().serialize( o.type ));
		}
		if (!childPropertiesToIgnore.contains("hostname")) {
			ret.put("hostname",  GwtSerDerUtils.STRING.serialize( o.hostname ));
		}
		if (!childPropertiesToIgnore.contains("protocol")) {
			ret.put("protocol",  GwtSerDerUtils.STRING.serialize( o.protocol ));
		}
		if (!childPropertiesToIgnore.contains("baseDn")) {
			ret.put("baseDn",  GwtSerDerUtils.STRING.serialize( o.baseDn ));
		}
		if (!childPropertiesToIgnore.contains("loginDn")) {
			ret.put("loginDn",  GwtSerDerUtils.STRING.serialize( o.loginDn ));
		}
		if (!childPropertiesToIgnore.contains("loginPw")) {
			ret.put("loginPw",  GwtSerDerUtils.STRING.serialize( o.loginPw ));
		}
		if (!childPropertiesToIgnore.contains("filter")) {
			ret.put("filter",  GwtSerDerUtils.STRING.serialize( o.filter ));
		}
		if (!childPropertiesToIgnore.contains("allCertificate")) {
			ret.put("allCertificate",  GwtSerDerUtils.BOOLEAN.serialize( o.allCertificate ));
		}
		if (!childPropertiesToIgnore.contains("entryUUID")) {
			ret.put("entryUUID",  GwtSerDerUtils.STRING.serialize( o.entryUUID ));
		}
		if (!childPropertiesToIgnore.contains("modifyTimeStampAttr")) {
			ret.put("modifyTimeStampAttr",  GwtSerDerUtils.STRING.serialize( o.modifyTimeStampAttr ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}