/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2024
  *
  * This file is part of Blue Mind. Blue Mind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License)
  * or the CeCILL as published by CeCILL.info (version 2 of the License).
  *
  * There are special exceptions to the terms and conditions of the
  * licenses as they are applied to this program. See LICENSE.txt in
  * the directory of this program distribution.
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.cli.sds;

import java.io.File;
import java.util.Optional;

import net.bluemind.cli.cmd.api.CliContext;
import net.bluemind.cli.cmd.api.ICmdLet;
import net.bluemind.cli.cmd.api.ICmdLetRegistration;
import picocli.CommandLine.Command;
import picocli.CommandLine.Option;

@Command(name = "check", description = "Check SDS objets availability")
public class SdsCheckCommand implements ICmdLet, Runnable {
	private CliContext ctx;

	public SdsCheckCommand() {
		// OK
	}

	@Override
	public Runnable forContext(CliContext ctx) {
		this.ctx = ctx;
		return this;
	}

	@Option(names = "--workers", description = "run with X workers")
	public int workers = 4;

	@Option(names = "--temporary-download-folder", description = "folder of destination for temporary downloads")
	public File tempDownloadDir = new File("/tmp");

	@Override
	public void run() {
		ctx.info("Checking emails...");
		if (!tempDownloadDir.isDirectory() || !tempDownloadDir.canWrite()) {
			ctx.error("{} is not a directory or is not writable", tempDownloadDir);
			return;
		}
		SdsObjectChecker checker = new SdsObjectChecker(ctx, workers, tempDownloadDir);
		checker.check();
	}

	public static class Reg implements ICmdLetRegistration {
		@Override
		public Optional<String> group() {
			return Optional.of("sds");
		}

		@Override
		public Class<? extends ICmdLet> commandClass() {
			return SdsCheckCommand.class;
		}
	}
}