import { type App } from "vue";

import { default as AlertStore } from "@bluemind/alert.store";
import router from "@bluemind/router";
import store from "@bluemind/store";
import { extend } from "@bluemind/vuex-router";

import PreferencesStore from "../preferences/store";
import RootAppStore from "../rootAppStore";
import SettingsStore from "../settingsStore";

export const StoreModule = {
    install: (app: App) => {
        extend(router, store);
        store.registerModule("alert", AlertStore);
        store.registerModule("root-app", RootAppStore);
        store.registerModule("settings", SettingsStore);
        store.registerModule("preferences", PreferencesStore);
        app.use(store);
    }
};
