import VueBus from "@bluemind/vue-bus";

export const ServiceWorkerModule = {
    install: async () => {
        if ("serviceWorker" in navigator) {
            try {
                const registration = await navigator.serviceWorker.register("service-worker.js");

                registration.addEventListener("updatefound", () => {
                    const newWorker = registration.installing;
                    newWorker?.addEventListener("statechange", () => {
                        if (newWorker.state === "installed" && registration.active) {
                            const client = new VueBus.Client();
                            client.$emit("serviceWorkerUpdated");
                        }
                    });
                });

                // eslint-disable-next-line no-console
                console.log("Registration succeeded. Scope is " + registration.scope);
            } catch (error) {
                // eslint-disable-next-line no-console
                console.log("Registration failed with " + error);
            }
        }
    }
};
