import { markRaw, onBeforeUnmount, onMounted } from "vue";

import { AlertTypes } from "@bluemind/bluetiful";

import store from "@bluemind/store";

import TimezoneAlert from "../components/alerts/TimezoneAlert.vue";

import { useCookieSession } from "./useCookieSession";

const alertUid = "timezoneuuid";
export function useTimezoneChecker(systemAlertService) {
    const alertPayload = {
        uid: alertUid,
        type: AlertTypes.INFO,
        renderer: {
            component: markRaw(TimezoneAlert),
            props: { setTimezoneCookie }
        }
    };
    const { dispatchSystemAlert, removeSystemAlert } = systemAlertService;

    const userAlertTimezonePreferencesCookie = useCookieSession("userAlertTimezonePreferences", {
        timezone: systemTimezone(),
        alertClosedByUser: false
    });
    function checkTimezone() {
        const { alertClosedByUser, timezone } = userAlertTimezonePreferencesCookie.getValue();
        if (isTimezoneDifferent() && (!alertClosedByUser || timezone !== systemTimezone())) {
            dispatchSystemAlert(alertPayload);
            setTimezoneCookie(systemTimezone(), false);
        } else {
            removeSystemAlert({ uid: alertUid });
        }
    }

    let checkTimezoneIntervalId = null;

    function startIntervalTimezoneChecker() {
        return setInterval(checkTimezone, 1000 * 60);
    }

    function stopIntervalTimezoneChecker() {
        clearInterval(checkTimezoneIntervalId);
    }

    function isTimezoneDifferent() {
        const { timezone, timezone_difference_reminder } = store.state.settings || {};
        return timezone_difference_reminder === "true" && timezone !== systemTimezone();
    }

    function setTimezoneCookie(timezone, preference) {
        userAlertTimezonePreferencesCookie.setValue({
            timezone: timezone,
            alertClosedByUser: preference
        });
    }

    onBeforeUnmount(() => {
        stopIntervalTimezoneChecker();
    });
    onMounted(() => {
        checkTimezoneIntervalId = startIntervalTimezoneChecker();
    });

    return { checkTimezone };
}

function systemTimezone() {
    return Intl.DateTimeFormat().resolvedOptions().timeZone;
}
