import { CRITERIA_MATCHERS, CRITERIA_TARGETS, CRITERIA_OPERATORS } from "../filterRules.js";

import PrefFilterRuleContactCriterion from "./PrefFilterRuleContactCriterion";
import PrefFilterRuleContactCriterionEditor from "./PrefFilterRuleContactCriterionEditor";
import PrefFilterRuleCriterion from "./PrefFilterRuleCriterion";
import PrefFilterRuleHeaderCriterionEditor from "./PrefFilterRuleHeaderCriterionEditor";
import PrefFilterRuleTextCriterion from "./PrefFilterRuleTextCriterion";
import PrefFilterRuleTextCriterionEditor from "./PrefFilterRuleTextCriterionEditor";

export default [
    {
        match: criterion =>
            [CRITERIA_TARGETS.FROM, CRITERIA_TARGETS.TO].includes(criterion.target.type) &&
            [CRITERIA_MATCHERS.EQUALS].includes(criterion.matcher),

        name: (criterion, i18n) => defaultName(criterion, i18n),
        viewer: PrefFilterRuleContactCriterion,
        editor: PrefFilterRuleContactCriterionEditor,
        priority: 0
    },
    {
        match: criterion =>
            [CRITERIA_TARGETS.FROM, CRITERIA_TARGETS.TO, CRITERIA_TARGETS.BODY, CRITERIA_TARGETS.SUBJECT].includes(
                criterion.target.type
            ) && [CRITERIA_MATCHERS.CONTAINS].includes(criterion.matcher),
        name: (criterion, i18n) => defaultName(criterion, i18n),
        viewer: PrefFilterRuleTextCriterion,
        editor: PrefFilterRuleTextCriterionEditor,
        priority: 0
    },
    {
        match: criterion =>
            [CRITERIA_TARGETS.SUBJECT].includes(criterion.target.type) &&
            [CRITERIA_MATCHERS.EQUALS].includes(criterion.matcher),
        name: (criterion, i18n) => defaultName(criterion, i18n),
        viewer: PrefFilterRuleTextCriterion,
        editor: PrefFilterRuleTextCriterionEditor,
        priority: 0
    },
    {
        match: criterion =>
            [CRITERIA_TARGETS.HEADER].includes(criterion.target.type) &&
            [CRITERIA_MATCHERS.EQUALS, CRITERIA_MATCHERS.CONTAINS].includes(criterion.matcher),
        name: (criterion, i18n) => defaultName(criterion, i18n),
        viewer: PrefFilterRuleTextCriterion,
        editor: PrefFilterRuleHeaderCriterionEditor,
        fullEditor: true,
        priority: 0
    },
    {
        match: criterion =>
            [CRITERIA_TARGETS.HEADER].includes(criterion.target.type) &&
            [CRITERIA_MATCHERS.EXISTS].includes(criterion.matcher),
        name: (criterion, i18n) => defaultName(criterion, i18n),
        viewer: PrefFilterRuleCriterion,
        editor: PrefFilterRuleHeaderCriterionEditor,
        fullEditor: true,
        priority: 0
    }
];

function defaultName(criterion, vueI18N) {
    const target = vueI18N.t(`preferences.mail.filters.target.${criterion.target.type}`, {
        name: criterion.target.name
    });
    const matcher = vueI18N.t(`preferences.mail.filters.matcher.${criterion.matcher}`);
    return `${target} ${matcher}`;
}

export function checkCompatibility(criteria) {
    if (criteria.operator === CRITERIA_OPERATORS.OR) {
        return true;
    }
    return criteriaCompatibility(CRITERIA_TARGETS.FROM) && criteriaCompatibility(CRITERIA_TARGETS.SUBJECT);

    function criteriaCompatibility(targetType) {
        return criteria.values.filter(value => matchIncompatibleCondition(value, targetType)).length <= 1;
    }
}

export function findCriteriaIncompatibleIndexes(criteria) {
    if (criteria.operator === CRITERIA_OPERATORS.OR) {
        return [];
    }

    const incompatibleIndexes = [];

    const conditions = new Map([
        [CRITERIA_TARGETS.FROM, false],
        [CRITERIA_TARGETS.SUBJECT, false]
    ]);

    criteria.values.forEach((value, index) => {
        const targetType = value.target?.type;
        const isEqualMatcher = value.matcher === CRITERIA_MATCHERS.EQUALS;

        if (isEqualMatcher && conditions.has(targetType)) {
            if (conditions.get(targetType)) {
                incompatibleIndexes.push(index);
            } else {
                conditions.set(targetType, true);
            }
        }
    });

    return incompatibleIndexes;
}

function matchIncompatibleCondition(value, targetType) {
    return value.target?.type === targetType && value.matcher === CRITERIA_MATCHERS.EQUALS;
}
